Attribute VB_Name = "modFilters"
'-----------------------------------------------------
' MirageBot Filters Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public UserFilters() As String, MessageFilters() As String

Public Sub AddUserFilter(ByVal Username As String)
On Error GoTo hErr
    Dim i As Integer, Count As Long, User As String
    User = LCase$(Suffix(Username))
    Count = UBound(UserFilters)
    For i = 0 To Count
        If LenB(UserFilters(i)) <> 0 Then
            If LCase$(UserFilters(i)) = User Then Exit Sub
        End If
    Next i
    ReDim Preserve UserFilters(UBound(UserFilters) + 1)
    UserFilters(UBound(UserFilters)) = Username
    SaveUserFilters
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Filters", "AddUserFilter"
End Sub

Public Function IsUserFiltered(ByVal Username As String) As Boolean
On Error GoTo hErr
    Dim i As Integer, Count As Long, User As String
    User = LCase$(Suffix(Username))
    Count = UBound(UserFilters)
    For i = 0 To Count
        If LenB(UserFilters(i)) <> 0 Then
            If InStrB(UserFilters(i), "*") > 0 Or InStrB(UserFilters(i), "?") <> 0 Then
                If Matches(User, UserFilters(i)) Then IsUserFiltered = True: Exit Function
            Else
                If LCase$(UserFilters(i)) = User Then IsUserFiltered = True: Exit Function
            End If
        End If
    Next i
    Exit Function
hErr:
    ErrorHandler Err, Erl, "Filters", "IsUserFiltered"
End Function

Public Function IsMessageFiltered(ByVal Message As String) As Boolean
On Error GoTo hErr
    Dim i As Integer, msg As String, Count As Long
    msg = LCase$(Suffix(Message))
    Count = UBound(MessageFilters)
    For i = 0 To Count
        If LenB(MessageFilters(i)) <> 0 Then
            If InStrB(MessageFilters(i), "*") > 0 Or InStrB(MessageFilters(i), "?") <> 0 Then
                If Matches(Message, MessageFilters(i)) Then IsMessageFiltered = True: Exit Function
            Else
                If LCase$(MessageFilters(i)) = msg Then IsMessageFiltered = True: Exit Function
            End If
        End If
    Next i
    Exit Function
hErr:
    ErrorHandler Err, Erl, "Filters", "IsMessageFiltered"
End Function

Public Sub LoadUserFilters()
On Error GoTo hErr
    ReDim UserFilters(0)
    Dim strLine As String, strFile As String, FF As Integer
    strFile = AppData & "Data\Preferences\Filters\Users.txt"
    CreateFile strFile
    FF = FreeFile
    Open strFile For Input As #FF
        Do Until EOF(FF) Or Err
        Line Input #FF, strLine
            If LenB(strLine) <> 0 Then
                If LenB(UserFilters(0)) = 0 Then
                    UserFilters(0) = strLine
                Else
                    ReDim Preserve UserFilters(UBound(UserFilters) + 1)
                    UserFilters(UBound(UserFilters)) = strLine
                End If
            End If
        Loop
    Close #FF
    Exit Sub
hErr:
    Close #FF
    ErrorHandler Err, Erl, "Filters", "LoadUserFilters"
End Sub

Public Sub SaveUserFilters()
On Error GoTo hErr
    Dim strLine As String, strFile As String, FF As Integer
    strFile = AppData & "Data\Preferences\Filters\Users.txt"
    CreateFile strFile
    FF = FreeFile
    Open strFile For Output As #FF
        Dim i As Integer
        For i = 0 To UBound(UserFilters)
            If LenB(UserFilters(i)) > 0 Then
                Print #FF, UserFilters(i)
            End If
        Next i
    Close #FF
    Exit Sub
hErr:
    Close #FF
    ErrorHandler Err, Erl, "Filters", "SaveUserFilters"
End Sub

Public Sub LoadMessageFilters()
On Error GoTo hErr
    ReDim MessageFilters(0)
    Dim strLine As String, strFile As String, FF As Integer
    strFile = AppData & "Data\Preferences\Filters\Messages.txt"
    CreateFile strFile
    FF = FreeFile
    Open strFile For Input As #FF
        Do Until EOF(FF) Or Err
        Line Input #FF, strLine
            If LenB(strLine) <> 0 Then
                If LenB(MessageFilters(0)) = 0 Then
                    MessageFilters(0) = strLine
                Else
                    ReDim Preserve MessageFilters(UBound(MessageFilters) + 1)
                    MessageFilters(UBound(MessageFilters)) = strLine
                End If
            End If
        Loop
    Close #FF
    Exit Sub
hErr:
    Close #FF
    ErrorHandler Err, Erl, "Filters", "LoadMessageFilters"
End Sub

Public Sub SaveMessageFilters()
On Error GoTo hErr
    Dim strLine As String, strFile As String, FF As Integer
    strFile = AppData & "Data\Preferences\Filters\Messages.txt"
    CreateFile strFile
    FF = FreeFile
    Open strFile For Output As #FF
        Dim i As Integer
        For i = 0 To UBound(MessageFilters)
            If LenB(MessageFilters(i)) > 0 Then
                Print #FF, MessageFilters(i)
            End If
        Next i
    Close #FF
    Exit Sub
hErr:
    Close #FF
    ErrorHandler Err, Erl, "Filters", "SaveMessageFilters"
End Sub

